/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/

package cnrg.itx.datax.jaudio;

import java.util.*;

public class JAudioOut
{
	//////////////////////////////////////////////////////////////////////
	//																	//
	//				 CLASS MEMBER VARIABLES								//
	//																	//
	//////////////////////////////////////////////////////////////////////

	protected JAudioDevice device;
	protected Queue blockQueue;

	//////////////////////////////////////////////////////////////////////
	//																	//
	//					  CLASS METHODS									//
	//																	//
	//////////////////////////////////////////////////////////////////////

	//////////////////////////////////////////////////////////////////////
	//
	//	JAudioOut::JAudioOut()
	//
	//	Description:
	//		JAudioOut constructor.
	//	
	//	Parameters:
	//		device:  The JAudioDevice to which this JAudio belongs.
	//
	//	Returns:
	//		Nothing.
	//
	//////////////////////////////////////////////////////////////////////
	protected JAudioOut(JAudioDevice device) 
	{
		this.device = device;
		blockQueue = new Queue();
	}

	//////////////////////////////////////////////////////////////////////
	//
	//	JAudioOut::start() / stop()
	//
	//	Description:
	//		Starts and stops the JAudioOut.
	//	
	//	Parameters:
	//		None.
	//
	//	Returns:
	//		Nothing.
	//
	//////////////////////////////////////////////////////////////////////
	public void start() throws JAudioException 
	{
		startN();
		device.checkError();
	}
	public void stop() throws JAudioException 
	{
		stopN();
		device.checkError();
	}

	//////////////////////////////////////////////////////////////////////
	//
	//	JAudioOut::addBlock()
	//
	//	Description:
	//		Adds a JAudioBlock to the input queue.
	//	
	//	Parameters:
	//		block:	The JAudioBlock to add to the input queue.
	//
	//	Returns:
	//		Nothing.
	//
	//////////////////////////////////////////////////////////////////////
	public void putBlock(JAudioBlock block) throws JAudioException 
	{
		if (!block.grabUsedOutLock()) 
		{
			throw new JAudioException("Block is already in use, can't do output");
		}

		// Add the block to the output queue (to keep GC happy) and then send
		// it to the audio device
		blockQueue.Push(block);
		putBlockN(block);
		device.checkError();
	}
	
	//////////////////////////////////////////////////////////////////////
	//																	//
	//					  CLASS HELPER METHODS							//
	//																	//
	//////////////////////////////////////////////////////////////////////

	// All native methods
	private native void startN();
	private native void putBlockN(JAudioBlock block);
	private native void stopN();
}
